/*
	File:		DRMStaticData.c

	Description:This file contains all the static data for the application-based DRM
				protection.

				It's ok to include this file in different files of your project.  
				You'll get extra copies of the data, but it's all constant data 
				and will make hacking your application more difficult.

				Note that you should still take the time to make your own version of 
				this code so an automated hacking tool cannot strip this code out of
				your PRC.

	Author:		

	Copyright:	Copyright  2003 by Tapwave, Inc.

	Disclaimer:	IMPORTANT:  This Tapwave software is provided by Tapwave, Inc. ("Tapwave").  Your 
				use is subject to and governed by terms and conditions of the Software Development 
				Kit Agreement ("SDK Agreement") between you and Tapwave.  If you have not entered 
				into Tapwaves standard SDK Agreement with Tapwave, you have no right or license 
				to use, reproduce, modify, distribute or otherwise exploit this Tapwave software.  
				You may obtain a copy of Tapwaves standard SDK Agreement by calling 650-960-1817
				or visiting Tapwave at http://www.tapwave.com/developers/. 

	Change History (most recent first):
				
*/

// the application key is owned and defined by the developer
static const TwSecPublicKeyType gAppPublicKey = { {
0x30,0x81,0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,
0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,0x81,
0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0xea,
0x0f,0xc9,0xb7,0x3e,0xb5,0x21,0x35,0x96,0x6c,0x37,
0xfb,0xcd,0x0e,0x7e,0x41,0x5c,0x3e,0x2d,0x7a,0x49,
0x14,0xba,0xe3,0x0e,0x20,0xe6,0xcf,0x44,0x1e,0x5c,
0xc2,0x76,0x68,0x7b,0xb9,0xd9,0x93,0xbf,0x73,0x27,
0x50,0x9a,0x86,0xf6,0x66,0xb7,0x10,0x4c,0xf8,0x46,
0x1d,0x83,0x28,0xb9,0x01,0xaf,0xf7,0x6c,0xc4,0xa3,
0x79,0x26,0x76,0x40,0xc7,0xa9,0xc9,0x9a,0x61,0x4a,
0x85,0xdb,0x2b,0x18,0xe9,0xe9,0xea,0x3b,0x60,0xf9,
0xef,0x32,0x01,0x19,0xf6,0x30,0x68,0x49,0x57,0x3b,
0xf2,0x6e,0xba,0xd7,0x6e,0x1b,0x9c,0x6f,0xb6,0x9d,
0x55,0x65,0xb7,0x44,0xe9,0x3b,0x85,0x22,0x2f,0x51,
0x66,0x19,0x55,0x2f,0xa3,0x6d,0xe7,0x84,0x6d,0x4d,
0x12,0x64,0x4d,0x2b,0xef,0x5a,0x51,0x02,0x03,0x01,
0x00,0x01 
} };

static const UInt8 mem_fail[] = {
	0x73,0x6d,0x61,0x6c,0x6c,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x53,0x54,0x52,0x54,0x61,0x70,0x70,0x6c,
	0x63,0x6f,0x64,0x65,0x00,0x00,0x00,0x01,
	0x00,0x00,0x00,0x01,0x48,0x7a,0x00,0x04,
	0x06,0x97,0x00,0x00,0x00,0x0a,0x4e,0x75,
	0x70,0x00,0x4e,0x75,0x4e,0x56,0xff,0xf4,
	0x2f,0x03,0x48,0x6e,0xff,0xf4,0x48,0x6e,
	0xff,0xf8,0x48,0x6e,0xff,0xfc,0x4e,0x4f,
	0xa0,0x8f,0x36,0x00,0x4f,0xef,0x00,0x0c,
	0x67,0x18,0x48,0x6d,0xff,0xe4,0x3f,0x3c,
	0x00,0x32,0x48,0x6d,0xff,0xd6,0x4e,0x4f,
	0xa0,0x84,0x70,0x00,0x4f,0xef,0x00,0x0a,
	0x60,0x2a,0x21, // <-- was 0x20
	0x6e,0xff,0xfc,0x3f,0x28,
	0x00,0x06,0x2f,0x28,0x00,0x02,0x3f,0x10,
	0x4e,0xba,0xff,0xb6,0x26,0x00,0x2f,0x2e,
	0xff,0xf4,0x2f,0x2e,0xff,0xf8,0x2f,0x2e,
	0xff,0xfc,0x4e,0x4f,0xa0,0x90,0x20,0x03,
	0x4f,0xef,0x00,0x14,0x26,0x1f,0x4e,0x5e,
	0x4e,0x75,0x8b,0x5f,0x5f,0x53,0x74,0x61,
	0x72,0x74,0x75,0x70,0x5f,0x5f,0x00,0x00,
	0x64,0x61,0x74,0x61,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x4c,0xff,0xff,0xff,0xd6,
	0x8e,0x53,0x74,0x61,0x72,0x74,0x75,0x70,
	0x43,0x6f,0x64,0x65,0x2e,0x63,0x00,0x45,
	0x20,0x72,0x8d,0x6f,0x72,0x20,0x6c,0x61,
	0x75,0x6e,0x63,0x68,0x69,0x6e,0x67,0x20,
	0x61,0x20,0x70,0x87,0x6c,0x69,0x63,0x61,
	0x74,0x69,0x6f,0x6e,0x40,0x00,0x00,0x00,
	0x00,0x28,0x00,0x00,0x00,0x00,0x28,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x63,0x6f,0x64,0x65,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,
	0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x20,
	0x00,0x00,0x3f,0x3c,0x00,0x01,0xa9,0xf0,
	0x74,0x41,0x49,0x4e,0x00,0x00,0x03,0xe8,
	0x53,0x74,0x61,0x72,0x74,0x65,0x72,0x00,
	0x74,0x76,0x65,0x72,0x00,0x00,0x03,0xe8,
	0x31,0x2e,0x30,0x00
};

static const UInt8 mem[] = {
	0x73,0x6d,0x61,0x6c,0x6c,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x53,0x54,0x52,0x54,0x61,0x70,0x70,0x6c,
	0x63,0x6f,0x64,0x65,0x00,0x00,0x00,0x01,
	0x00,0x00,0x00,0x01,0x48,0x7a,0x00,0x04,
	0x06,0x97,0x00,0x00,0x00,0x0a,0x4e,0x75,
	0x70,0x00,0x4e,0x75,0x4e,0x56,0xff,0xf4,
	0x2f,0x03,0x48,0x6e,0xff,0xf4,0x48,0x6e,
	0xff,0xf8,0x48,0x6e,0xff,0xfc,0x4e,0x4f,
	0xa0,0x8f,0x36,0x00,0x4f,0xef,0x00,0x0c,
	0x67,0x18,0x48,0x6d,0xff,0xe4,0x3f,0x3c,
	0x00,0x32,0x48,0x6d,0xff,0xd6,0x4e,0x4f,
	0xa0,0x84,0x70,0x00,0x4f,0xef,0x00,0x0a,
	0x60,0x2a,0x20,0x6e,0xff,0xfc,0x3f,0x28,
	0x00,0x06,0x2f,0x28,0x00,0x02,0x3f,0x10,
	0x4e,0xba,0xff,0xb6,0x26,0x00,0x2f,0x2e,
	0xff,0xf4,0x2f,0x2e,0xff,0xf8,0x2f,0x2e,
	0xff,0xfc,0x4e,0x4f,0xa0,0x90,0x20,0x03,
	0x4f,0xef,0x00,0x14,0x26,0x1f,0x4e,0x5e,
	0x4e,0x75,0x8b,0x5f,0x5f,0x53,0x74,0x61,
	0x72,0x74,0x75,0x70,0x5f,0x5f,0x00,0x00,
	0x64,0x61,0x74,0x61,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x4c,0xff,0xff,0xff,0xd6,
	0x8e,0x53,0x74,0x61,0x72,0x74,0x75,0x70,
	0x43,0x6f,0x64,0x65,0x2e,0x63,0x00,0x45,
	0x20,0x72,0x8d,0x6f,0x72,0x20,0x6c,0x61,
	0x75,0x6e,0x63,0x68,0x69,0x6e,0x67,0x20,
	0x61,0x20,0x70,0x87,0x6c,0x69,0x63,0x61,
	0x74,0x69,0x6f,0x6e,0x40,0x00,0x00,0x00,
	0x00,0x28,0x00,0x00,0x00,0x00,0x28,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x63,0x6f,0x64,0x65,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,
	0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x20,
	0x00,0x00,0x3f,0x3c,0x00,0x01,0xa9,0xf0,
	0x74,0x41,0x49,0x4e,0x00,0x00,0x03,0xe8,
	0x53,0x74,0x61,0x72,0x74,0x65,0x72,0x00,
	0x74,0x76,0x65,0x72,0x00,0x00,0x03,0xe8,
	0x31,0x2e,0x30,0x00
};

static const UInt8 mem_sig[] = {
	0xa8,0x22,0xb0,0xf3,0x43,0x6e,0x7c,0x75,
	0x79,0xb9,0x71,0x39,0x01,0x0e,0x07,0x65,
	0x0b,0xca,0x8b,0xf2,0xf9,0xd4,0xb0,0xd0,
	0x64,0xf1,0x48,0xa4,0xfc,0x94,0x2c,0x23,
	0x21,0x3f,0xee,0xf1,0x14,0xd2,0x03,0x5c,
	0x0e,0x01,0x46,0x5d,0x00,0x75,0x6a,0x6f,
	0xe6,0x0e,0x4a,0x8e,0xc5,0xc0,0xd7,0x5f,
	0x3a,0x58,0x5f,0xcd,0x02,0x3a,0x1d,0x76,
	0xb9,0x1a,0x0f,0x78,0xa8,0x7c,0xc1,0xa5,
	0xb3,0xf9,0x01,0x86,0x8e,0x7f,0x2e,0x11,
	0xf8,0x16,0x23,0x3a,0x9c,0xf8,0x5f,0xf2,
	0xdf,0x36,0x24,0x2e,0x9a,0x67,0xf6,0xaf,
	0x21,0xa3,0x32,0x99,0xc9,0x34,0x57,0xdf,
	0x58,0xf9,0xa6,0x1b,0xaf,0x33,0xcc,0xa1,
	0x36,0x6b,0xd4,0xba,0xd0,0xa1,0x0a,0xf0,
	0xec,0xe4,0x52,0x0c,0x24,0x6c,0xad,0xe5
};

static const UInt8 gMemSigKey[] = {
	0x30,0x81,0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,
	0x05,0x00,0x03,0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0xbf,0xf3,0x08,
	0xba,0xc1,0x1b,0xb9,0x1d,0x53,0x7d,0x9f,0xa2,0x62,0xf9,0xfe,0xe1,0x2a,0x12,0x6f,
	0x55,0x1c,0x6f,0xfa,0x2e,0x44,0x0d,0x37,0x01,0xe3,0x69,0x80,0xdc,0x35,0x27,0x74,
	0x59,0x11,0x9c,0x0c,0xe0,0x5c,0x2f,0xb2,0xf0,0xfa,0x63,0x5a,0xfe,0x6d,0xe3,0xff,
	0x75,0x23,0x71,0x20,0xb6,0x24,0x45,0x20,0x5c,0x7e,0xc3,0x1a,0x5f,0xea,0x09,0x93,
	0x11,0x5f,0x95,0x7b,0x81,0xa3,0x25,0x24,0xe9,0x80,0xa2,0x86,0xb1,0x8e,0xf1,0x99,
	0xc9,0x21,0x6b,0x46,0x23,0x49,0x16,0x67,0xcb,0x83,0x5e,0x40,0x1f,0x45,0x3a,0x82,
	0xaf,0xee,0xe6,0xd9,0x0f,0xb3,0xbd,0xd9,0x82,0x9f,0x91,0xac,0x17,0x4f,0x2d,0x59,
	0x18,0xd8,0x11,0xc3,0x67,0x63,0xf7,0xb1,0x8d,0x31,0xa2,0x85,0xad,0x02,0x03,0x01,
	0x00,0x01
};

static const UInt32 gScatter[256] = { // none of these are rotations of any other
	// You should at LEAST reorder these values!
	0x0af052e0,0x2f965515,0x66215113,0x0ded167f,0x56db013f,0x129c741c,0x79456d7f,0x439e2f0f,
	0x69b12598,0x3081151a,0x53c21d20,0x10f265ed,0x35177ef4,0x563f60e7,0x41c34567,0x0dc22910,
	0x6f7a32ee,0x456954a5,0x7b5350d4,0x5fa4016e,0x7ccc462e,0x5e82034c,0x2a0f1b12,0x6a176112,
	0x50c57734,0x7a2403d0,0x0fc40fb1,0x087f487f,0x0cb16938,0x77414579,0x08483426,0x1d9f7c2a,
	0x29143c6a,0x191a5022,0x50327b3b,0x685f466a,0x2b59710b,0x2d6b4f18,0x28175bb6,0x5af24d21,
	0x5a156cc2,0x2dfd4fb6,0x06c067af,0x62af4876,0x4241052d,0x567053c6,0x0ada110a,0x1223520c,
	0x0e2955f8,0x7b0503a1,0x7af2383e,0x52901929,0x201f68ad,0x6da01e20,0x7d0543d6,0x66d571b6,
	0x24c918eb,0x65b550f4,0x72d61905,0x1ee31032,0x2eff4820,0x73134a6a,0x4a424dd2,0x3bcc4213,
	0x500b4f66,0x727f0ee8,0x2cfb2b8c,0x4d6e573c,0x52e81e4f,0x23c6338d,0x5e256148,0x5d0e705b,
	0x31743c04,0x16201395,0x4c4651b1,0x2aea3b07,0x6eca40e0,0x756f3e80,0x397d66a5,0x62c209de,
	0x0f9e64d7,0x6aae5dcf,0x76ec12c5,0x0d9a662c,0x24b16625,0x69b00a89,0x5bff684d,0x2b3f2d0a,
	0x013a0ba6,0x5c5d4b78,0x06d6755d,0x57d03693,0x17620f5b,0x632f53aa,0x20c67678,0x34441c6a,
	0x08f0662c,0x5bd0740f,0x1c3c7ba6,0x158a1fa7,0x396345a3,0x4f7d3550,0x0c22777d,0x0bea195a,
	0x66545f31,0x562809cc,0x2db92c14,0x3e8e3ab3,0x56f70dc1,0x4d930cba,0x11de3f56,0x323411fb,
	0x57bb488c,0x7f6b040e,0x6ad04738,0x73eb0c40,0x7b670b2f,0x730c290b,0x64ba655a,0x226160c9,
	0x6e8e2df6,0x2a8565b6,0x3dfd0245,0x4e016147,0x43790a83,0x676f09bd,0x4a0e5c1c,0x12e035fb,
	0x0be74c1c,0x067c6394,0x701445e7,0x5e686329,0x558b7a2a,0x5fed1ef2,0x0f6c7a11,0x77d62f9a,
	0x768912bb,0x78193350,0x34257ceb,0x58ba1b1b,0x2d45568c,0x0a0e24b3,0x2bb56e8f,0x484d1663,
	0x20031c11,0x6fc5223a,0x329738fd,0x33474027,0x79be7206,0x08f13818,0x355f2a07,0x208531d7,
	0x2c5d1d00,0x5102506f,0x383e653e,0x2ce43633,0x54f47653,0x5043237d,0x752412de,0x638f0e0a,
	0x2a636db2,0x57a4475c,0x53f82d87,0x2aa73e10,0x2ae358ef,0x7431696d,0x4f1f3e8b,0x7cb01339,
	0x3a252d7e,0x640a73d0,0x3ab11222,0x1b835477,0x5dc84afa,0x36e02bed,0x68fa49e8,0x58cc6943,
	0x49e555a0,0x3e7c60ee,0x1efa7f5d,0x2e8f101b,0x3d8420d3,0x4f382a42,0x58e57664,0x279e24fe,
	0x2f232996,0x5083361c,0x5ea45fc5,0x182477f1,0x49362115,0x1d6127f1,0x28532bab,0x261e337e,
	0x36a2071d,0x34e906fe,0x12c06c26,0x21dd5330,0x3f41549f,0x3ac63cc0,0x63f247aa,0x2e862a19,
	0x34613631,0x47b7237a,0x1fa07b8f,0x3a91794c,0x29fc3500,0x7fed626d,0x1b840f27,0x557b64fc,
	0x7c735bcf,0x256646cd,0x0881305d,0x15d02291,0x086f2821,0x34197235,0x68483189,0x5d4865b5,
	0x13a3390f,0x363467b5,0x44d3534b,0x065a21f9,0x0024243b,0x4724100e,0x42cd5ac6,0x382e4e31,
	0x66e71c35,0x0eec0c13,0x2d2c76e8,0x6e91352e,0x13fe6d47,0x172f7358,0x1fab2cfc,0x10203f99,
	0x77ef4660,0x51a6753a,0x7eba7832,0x31ce1b1e,0x4434638f,0x189a5756,0x7bfe3c1e,0x3f5e40ef,
	0x26e9317a,0x503841dd,0x27c31842,0x28213ca0,0x3a4139b0,0x15586bb6,0x070f0a56,0x2e7a6e57,
	0x47565a46,0x509e054e,0x708361c9,0x49392550,0x4d490654,0x573f038c,0x27e96bb7,0x478b5083,
};	

static UInt32 SimpleHash(UInt32 start, const UInt8 *data, UInt32 size){
	while(size--){
		start ^= gScatter[*data++];
		start = (start << 1) ^ (start >> 31);
	}
	return start;
}

// When you change the scatter data above.  These values will need to be changed too.
#define kHashOfRomKeys 1433483920UL
#define kHashOfAppKey  2120681350UL